;power meter/SWR software for butterfly demo board.
;By Steven Weber KD1JV for hobby use only. 


.include	"m169def.inc"

.equ	atbcd0	=2
.equ	atbcd1	=3
.equ	atbcd2	=4

.def	tbcd0	=r2
.def	tbcd1	=r3
.def	tbcd2	=r4

.def	temp	=r16
.def	temp1	=r17
.def	count	=r18
.def	flags	=r19
.def	dlycnt	=r20
.def	stemp	=r21
.def	seconds	=r22
.def	stemp2	=r23

.def	mc16uL	=r8		;multiplicand low byte
.def	mc16uH	=r9		;multiplicand high byte
.def	mp16uL	=r10		;multiplier low byte
.def	mp16uH	=r11		;multiplier high byte
.def	m16u0	=r10		;result byte 0 (LSB)
.def	m16u1	=r11		;result byte 1
.def	m16u2	=r12		;result byte 2
.def	m16u3	=r13		;result byte 3 (MSB)
.def	mcnt16u	=r18		;loop counter


.def	drem16uL=r1
.def	drem16uH=r2
.def	drem32uL=r3
.def	dd16uL	=r10
.def	dd16uH	=r11
.def	dd32uL	=r12
.def	dd32uH	=r13
.def	dv16uL	=r8
.def	dv16uh	=r9
.def	dcnt16u	=r18


.equ	sbcd0	=$160
.equ	sbcd1	=$161
.equ	sbcd2	=$162
.equ	sbcd3	=$163
.equ	vfl	=$164
.equ	vfh	=$165
.equ	vrl	=$166
.equ	vrh	=$167
.equ	swrs_l	=$168
.equ	swrs_h	=$169
.equ	swr_l	=$16a
.equ	swr_h	=$16b
.equ	swra_l	=$16c
.equ	swra_h	=$16d

.org	$0000


	jmp	reset
	
	nop	;2
	nop
	
	nop	;3
	nop
	
	jmp	pinch	;4
	
	
	nop	;5
	nop
	
	jmp	timer2	;6
	
	
	nop	;7
	nop
	
	nop	;8
	nop
	
	nop	;9
	nop
	
	nop	;10
	nop
	
	nop	;11
	nop
	
	jmp	timer	;12
	
	nop	;13
	nop
		
	nop	;14
	nop
	
	nop	;15
	nop
	
	nop	;16
	nop
	
	nop	;17
	nop
	
	nop	;18
	nop
	
	nop	;19
	nop
	
	reti
	
	
timer:	in	stemp,sreg
	inc	dlycnt
	out	sreg,stemp
	reti

timer2:	in	stemp2,sreg
	inc	seconds
	out	sreg,stemp2
	reti

pinch:	reti



reset:	ldi	temp,$50  ;low(ramend)
	out	spl,temp
	ldi	temp,$04 ;high(ramend)
	out 	sph,temp
	
	ldi	temp,$80
	sts	mcucr,temp
	sts	mcucr,temp
	clr	temp
	out	ddrf,temp
	out	portf,temp

	out	ddrb,temp
	ser	temp
	out	portb,temp
	
	
	;set up the lcd control registers, must be done in this order!

	ldi	temp,$b7
	sts	lcdcrb,temp
	ldi	temp,$03
	sts	lcdfrr,temp
	ldi	temp,$0f
	sts	lcdccr,temp
	ldi	temp,$80
	sts	lcdcra,temp
	clr	flags
	
	ldi	temp,$08
	sts	assr,temp
	ldi	temp,$03
	out	tccr0a,temp
	ldi	temp,$07
	sts	tccr2a,temp
	ldi	temp,$01
	sts	timsk0,temp
	sts	timsk2,temp
	
	clr	seconds	
	sei
	rjmp	wait
		
dshift:	sbrc	flags,1
	rjmp	shift3
	sbrs	flags,0
	rjmp	shiftl
	lsl	flags
	rjmp	dslp1	
	
shiftl:	sbr	flags,$01
	rjmp	dslp1

shift3:	cbr	flags,$02	
		
dslp1:	rcall	lcdwr
	sbis	pinb,4
	rjmp	dslp1	
	
	
wait:	
	clr	dlycnt
dwt2:	sbis	pinb,4
	rjmp	dshift
	sbis	pinb,7
	rjmp	shutdn
	cpi	dlycnt,50
	brne	dwt2
	ldi	temp,$c2	;set up A/D ect. 
	sts	admux,temp
	ldi	temp,$8c
	sts	adcsra,temp
	ldi	temp,$03
	out	smcr,temp
	sleep			;measure forward voltage
	clr	temp
	out	smcr,temp
	lds	temp,adcl
	mov	mp16ul,temp
	sts	vfl,temp
	lds	temp,adch
	mov	mp16uh,temp
	sts	vfh,temp
	rcall	mpy16u
	rcall	div16u
	rcall	bin2bcd16
	sts	sbcd0,tbcd0
	sts	sbcd1,tbcd1
	sts	sbcd2,tbcd2
	
	ldi	temp,$c1
	sts	admux,temp
	ldi	temp,$8c
	sts	adcsra,temp
	ldi	temp,$03
	out	smcr,temp
	sleep			;measure reverse voltage
	clr	temp
	out	smcr,temp
	lds	temp,adcl
	mov	mp16ul,temp
	sts	vrl,temp
	lds	temp,adch
	sts	vrh,temp
	rcall	swr
	rcall	lcdwr
	cpi	seconds,32
	breq	shutdn
	rjmp	wait
	

shutdn:	clr	temp
	sts	adcsra,temp
	sts	timsk2,temp
	sts	lcdcra,temp
	ldi	temp,$40
	sts	pcmsk1,temp
	ldi	temp,$80
	out	eimsk,temp
	clr	temp

	
	ldi	temp,$05
	out	smcr,temp
	sleep

	clr	temp
	out	smcr,temp
	out	eimsk,temp
	clr	seconds
	ldi	temp,$01
	sts	timsk2,temp
	ldi	temp,$80
	sts	lcdcra,temp
	rjmp	wait

;convert 24 bit binary to bcd

bin2bcd16:
	ldi	count,24
	clr	tbcd1
	clr	tbcd0
	clr	tbcd2
	
bbcdx_1:lsl	dd16uL
	rol	dd16uH
	rol	dd32uL
	rol	tbcd0
	rol	tbcd1
	rol	tbcd2
	dec	count
	brne	bbcdx_2
	ret

bbcdx_2:ldi	r30,atbcd2+1
	clr	zh
bbcdx_3:ld	temp1,-z
	subi	temp1,-$03
	sbrc	temp1,3
	st	z,temp1
	ld	temp1,z
	subi	temp1,-$30
	sbrc	temp1,7
	st	z,temp1
	cpi	zl,atbcd0
	brne	bbcdx_3
	rjmp	bbcdx_1

;multiply two 26 bit mumbers

mpy16u:	clc
	rol	mp16ul
	rol	mp16uh
	rol	mp16ul
	rol	mp16uh
	
	mov	mc16uL,mp16uL
	mov	mc16uH,mp16uH
	
mpy16a:	clr	m16u3		;clear 2 highest bytes of result
	clr	m16u2
	ldi	mcnt16u,16	;init loop counter
	lsr	mp16uH
	ror	mp16uL

m16u_1:	brcc	noad8		;if bit 0 of multiplier set
	add	m16u2,mc16uL	;add multiplicand Low to byte 2 of res
	adc	m16u3,mc16uH	;add multiplicand high to byte 3 of res
noad8:	ror	m16u3		;shift right result byte 3
	ror	m16u2		;rotate right result byte 2
	ror	m16u1		;rotate result byte 1 and multiplier High
	ror	m16u0		;rotate result byte 0 and multiplier Low
	dec	mcnt16u		;decrement loop counter
	brne	m16u_1		;if not done, loop more
	ret

;divide 32 bit number is dd registers by 100

div16u:	ldi	temp,100
	mov	dv16ul,temp
div16a:	clr	drem16uL	;clear remainder Low byte
	clr	drem16uH
	sub	drem32uL,drem32uL;clear remainder High byte and carry
	ldi	dcnt16u,33	;init loop counter
d16u_1:	rol	dd16uL		;shift left dividend
	rol	dd16uH
	rol	dd32uL
	rol	dd32uH
	dec	dcnt16u		;decrement counter
	brne	d16u_2		;if done
	ret			;    return
d16u_2:	rol	drem16uL	;shift dividend into remainder
	rol	drem16uH
	rol	drem32ul
	sub	drem16uL,dv16uL	;remainder = remainder - divisor
	
	brcc	d16u_3		;if result negative
	add	drem16uL,dv16uL	;    restore remainder

	clc			;    clear carry to be shifted into result
	rjmp	d16u_1		;else
d16u_3:	sec			;    set carry to be shifted into result
	rjmp	d16u_1


;divide 24 bit number in dd registers by 16 bit number in dv registers
	
div16:	clr	drem16uL	;clear remainder Low byte
	sub	drem16uH,drem16uH;clear remainder High byte and carry
	ldi	dcnt16u,25	;init loop counter
d16_1:	rol	dd16uL		;shift left dividend
	rol	dd16uH
	rol	dd32ul
	dec	dcnt16u		;decrement counter
	brne	d16_2		;if done
	ret			;    return
d16_2:	rol	drem16uL	;shift dividend into remainder
	rol	drem16uH
	sub	drem16uL,dv16uL	;remainder = remainder - divisor
	sbc	drem16uH,dv16uH	;
	brcc	d16_3		;if result negative
	add	drem16uL,dv16uL	;    restore remainder
	adc	drem16uH,dv16uH
	clc			;    clear carry to be shifted into result
	rjmp	d16_1		;else
d16_3:	sec			;    set carry to be shifted into result
	rjmp	d16_1
	ret


;calculate SWR Vf-Vr / Vf-Vr

swr:	lds	r9,vfl
	lds	r10,vfh
	
	lds	r11,vrl
	lds	r12,vrh
	
	add	r9,r11
	adc	r10,r12
	
	sts	swra_l,r9
	sts	swra_h,r10
	
	lds	r9,vfl
	lds	r10,vfh
	lds	r11,vrl
	lds	r12,vrh
	
	sub	r9,r11
	sbc	r10,r12
	
	brmi	error
	
	sts	swrs_l,r9
	sts	swrs_h,r10
	
	lds	mc16uL,swra_l
	
	lds	mc16uH,swra_h
	ldi	temp,$64
	mov	mp16ul,temp
	clr	mp16uH
	rcall	mpy16a

	lds	dv16ul,swrs_l
	lds	dv16uh,swrs_h
	
	rcall	div16
	rcall	bin2bcd16
	sts	swr_l,tbcd0
	sts	swr_h,tbcd1
	ret
	
error:	ldi	temp,$ff
	sts	swr_l,temp
	sts	swr_h,temp
	ret	
	
	
lcdwr:	sbrc	flags,0
	rjmp	lcdwr2
	sbrc	flags,1
	rjmp	lcdwr3
	ldi	xl,$08
	clr	xh
	ldi	yl,low(lcddr0)		;display 00.00W
	ldi	yh,high(lcddr0)
	lds	temp,sbcd2
	swap	temp
	cbr	temp,$f0
	rcall	gseg
	lds	temp,sbcd2
	cbr	temp,$f0
	rcall	gseg
	rcall	cmseg

	ldi	xl,$08
	ldi	yl,low(lcddr1)
	ldi	yh,high(lcddr1)
	

	ldi	temp,$0e
	rcall	gseg
	lds	temp,sbcd1
	swap	temp
	cbr	temp,$f0
	rcall	gseg
	rcall	cmseg
		
	ldi	xl,$08
	ldi	yl,low(lcddr2)
	ldi	yh,high(lcddr2)
	lds	temp,sbcd1
	cbr	temp,$f0
	rcall	gseg
	ldi	temp,$0c
	rcall	gseg
	rcall	cmseg
	ret



lcdwr2:	ldi	xl,$08			;display 0.000W
	clr	xh
	ldi	yl,low(lcddr0)
	ldi	yh,high(lcddr0)
	lds	temp,sbcd2
	cbr	temp,$f0
	rcall	gseg
	ldi	temp,$0e
	rcall	gseg
	rcall	cmseg

	ldi	xl,$08
	ldi	yl,low(lcddr1)
	ldi	yh,high(lcddr1)
	
	lds	temp,sbcd1
	swap	temp
	cbr	temp,$f0
	rcall	gseg
	lds	temp,sbcd1
	cbr	temp,$f0
	rcall	gseg
	rcall	cmseg	
	ldi	xl,$08
	ldi	yl,low(lcddr2)
	ldi	yh,high(lcddr2)
	lds	temp,sbcd0
	swap	temp
	cbr	temp,$f0
	rcall	gseg
	ldi	temp,$0c
	rcall	gseg
	rcall	cmseg
	ret
	
;display 00.00S (swr)	
	
lcdwr3:	ldi	xl,$08
	clr	xh
	ldi	yl,low(lcddr0)
	ldi	yh,high(lcddr0)
	
	lds	temp,swr_h
	swap	temp
	cbr	temp,$f0
	rcall	gseg
	lds	temp,swr_h
	cbr	temp,$f0
	rcall	gseg
	rcall	cmseg

	ldi	xl,$08
	ldi	yl,low(lcddr1)
	ldi	yh,high(lcddr1)
	ldi	temp,$0e
	rcall	gseg
	lds	temp,swr_l
	swap	temp
	cbr	temp,$f0
	rcall	gseg
	rcall	cmseg
		
	ldi	xl,$08
	ldi	yl,low(lcddr2)
	ldi	yh,high(lcddr2)
	lds	temp,swr_l
	cbr	temp,$f0
	rcall	gseg
	
	ldi	temp,$0d
	rcall	gseg
	rcall	cmseg
	ret


;this routine combines segement data into one packed byte
;and moves it to the lcd segement registers in extended I/O sram

cmseg:	swap	r8
	add	r8,r12
	swap	r8
	st	y,r8
	swap	r9
	add	r9,r13
	swap	r9
	std	y+5,r9
	swap	r10
	add	r10,r14
	swap	r10
	std	y+10,r10
	swap	r11
	add	r11,r15
	swap	r11
	std	y+15,r11
	ret


;this routine gets the segment data for the LCD from a look up table
;and puts the four bytes into working registers. 
;a high will turn on the segment. 
;segement data is in this order:
;bit number		chararacter segments arranged like this:
;76543210		    a		(top bar)
;0000k--a		f h j k b	(f- top side bar, h- left diaginal(center to top left corner),j- vertical center,k- right diginal(cneter to top right corner), b- right top side bar)
;0000jfhb		    gl		(g- left center, l- right center)
;0000legc		e p n m c	(e- left side bar,p- left diaginal (center to bottom left),n- vertical center, m- right digainal(center to bottom right corner), c- bottom right side bar
;0000mpnd		    d		(bottom bar)

gseg:	ldi	zl,low(2*segtable)
	ldi	zh,high(2*segtable)
	lsl	temp
	lsl	temp
	add	zl,temp
	clr	temp
	adc	zh,temp
	lpm	temp,z+
	st	x+,temp
	lpm	temp,z+
	st	x+,temp
	lpm	temp,z+
	st	x+,temp
	lpm	temp,z
	st	x+,temp
	ret

segtable:	.db	$09,$05	;0 $00
		.db	$05,$05

		.db	$08,$01	;1	$01
		.db	$01,$00

		.db	$01,$01	;2	$02
		.db	$0e,$01

		.db	$01,$01	;3	$03
		.db	$0b,$01

		.db	$00,$05	;4	$04
		.db	$0b,$00

		.db	$01,$04	;5	$05
		.db	$0b,$01

		.db	$01,$04	;6	$06
		.db	$0f,$01

		.db	$01,$01	;7	$07
		.db	$01,$00

		.db	$01,$05	;8	$08
		.db	$0f,$01

		.db	$01,$05	;9	$09
		.db	$0b,$00

		.db	$01,$05	;P	$0a
		.db	$0e,$00

		.db	$01,$04	;F	$0b
		.db	$0e,$00

		.db	$00,$05	;W	$0c
		.db	$05,$0c


		.db	$01,$02	;S	$0d
		.db	$00,$09
		
		
		.db	$00,$00	;^	$0e
		.db	$00,$0c
		
		.db	$00,$00	;-	$0f
		.db	$0a,$00
		
		
		

;		.db	$01,$05	;A	$0a
;		.db	$0f,$00
;
;		.db	$01,$09	;B	$0b
;		.db	$09,$03
;
;		.db	$01,$04	;C	$0c
;		.db	$04,$01
;
;		.db	$01,$09	;D	$0d
;		.db	$01,$03
;
;		.db	$01,$04	;E	$0e
;		.db	$0e,$01
;
;	
;		.db	$01,$04	;G	$10
;		.db	$0d,$01
;
;		.db	$00,$05	;H	$11
;		.db	$0f,$00
;		
;		.db	$00,$08	;I	$12
;		.db	$00,$02
;
;		.db	$00,$01	;J	$13
;		.db	$05,$01
;
;		.db	$08,$04	;K	$14
;		.db	$06,$08
;
;		.db	$00,$04	;L	$15
;		.db	$04,$01
;
;		.db	$08,$07	;M	$16
;		.db	$05,$00
;
;		.db	$00,$07	;N	$17
;		.db	$05,$08
;
;		.db	$01,$05	;O	$18
;		.db	$05,$01
;
;	
;		.db	$01,$05	;Q	$1a
;		.db	$05,$09
;
;
;
;
;		.db	$01,$08	;T	$1d
;		.db	$00,$02
;
;		.db	$00,$05	;U	$1e
;		.db	$05,$01
;
;		.db	$08,$04	;V	$1f
;		.db	$04,$04
;
;		.db	$00,$05	;W	$20
;		.db	$05,$0c
;
;		.db	$08,$02	;X	$21
;		.db	$00,$0c
;
;		.db	$08,$02	;Y	$22
;		.db	$00,$02
;
;		.db	$09,$00	;Z	$23
;		.db	$00,$05
;
;	
;
;		.db	$00,$08	;+	$25
;		.db	$0a,$02

	
